# Document Verification App (Python 3.8 / MySQL 8.0)

This project is prepared for Python 3.8.20 and MySQL 8.0 and is suitable for shared Linux hosting that supports Python/Flask and MySQL.

## Quick setup (shared hosting)

1. Create a virtualenv with Python 3.8 and activate it:
   ```bash
   python3.8 -m venv venv
   source venv/bin/activate
   ```
2. Install requirements:
   ```bash
   pip install -r requirements.txt
   ```
3. Create a MySQL database and user (see `init_db.sql` for schema).
4. Import `init_db.sql` into MySQL to create tables and demo records:
   ```bash
   mysql -u dbuser -p document_verification < init_db.sql
   ```
5. Create a `.env` file (use `.env.example` as reference) and set `DATABASE_URL`.
6. Run the app (for shared hosting you may use `gunicorn` or provider's WSGI options):
   ```bash
   flask run --host=0.0.0.0
   ```

## Demo account
- Email: demo@example.com
- Password: password123

Files:
- app.py
- templates/*.html
- static/styles.css
- init_db.sql (SQL schema + demo data)
